﻿using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.ModelsEnumTypes;

namespace PpmsDataWebService.Models
{
    public class ProviderIdentifier
    {
        [Key]
        public int Id { get; set; }

        public string Identifier { get; set; }

        public string ProviderName { get; set; }

        public ProviderIdentifierType ?ProviderIdentifierType { get; set; }

        public string EnumerationDate { get; set; }

        public bool SoleProprietor { get; set; }

        public string DeactivationReasonCode { get; set; }

        public string DeactivationDate { get; set; }

        public string ReactivationDate { get; set; }

        public string ReplacementNpiName { get; set; }

        public string OrganizationSubpart { get; set; }

        public string SubpartLegalBusinessName { get; set; }

        public string SubpartTaxId { get; set; }

        public virtual IQueryable<Provider> Provider { get; set; }
        
        public virtual IQueryable<ProviderIdentifier> ReplacementNpi { get; set; }

        public virtual IQueryable<Provider> Providers { get; set; }
     
        public virtual IQueryable<ProviderIdentifier> ProviderIdentifiers { get; set; }

    }
}